<?php

// product -----------------------------
vc_map( array (
    'base' 			=> 'avo_product',
    'name' 			=> __('Product', 'avo_plg'),
    'category' 		=> __('Avo', 'avo_plg'),
    'description' 	=> __('Create custom product element', 'avo_plg'),
    'params' 		=> array (
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Style', 'avo_plg' ),
            'param_name' => 'port_style',
            'value' => array(
                __( 'Style 1', 'avo_plg' ) => 'style-1',
                __( 'Style 2', 'avo_plg' ) => 'style-2',
                __( 'Style 3', 'avo_plg' ) => 'style-3',
            )
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Filter', 'avo_plg' ),
            'param_name' => 'filter',
            'value' => array(
                __( 'Show', 'avo_plg' ) => 'block',
                __( 'Hider', 'avo_plg' ) => 'none',
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Filter Alignment', 'avo_plg' ),
            'param_name' => 'filter_align',
            'value' => array(
                __( 'Left', 'avo_plg' ) => 'left',
                __( 'Center', 'avo_plg' ) => 'center',
                __( 'Right', 'avo_plg' ) => 'right',
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __('Item to display', 'avo_plg'),
            'param_name' => 'product_item',
            'value'   => __('8', 'avo_plg'),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Sort Product by Product Category', 'avo_plg' ),
            'param_name' => 'sort_cat',
            'value' => array(
                __( 'Yes', 'avo_plg' ) => 'yes',
                __( 'No', 'avo_plg' ) => 'no',
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Category to Show', 'avo_plg' ),
            'param_name' => 'blog_cat',
            'value' => array(
                avo_tax_choice(),
            ),
            'dependency' => array(
                'element' => 'sort_cat',
                'value' => array(
                    'yes',
                ),
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Orders', 'avo_plg' ),
            'param_name' => 'port_order',
            'value' => array(
                __( 'Descending', 'avo_plg' ) => 'DESC',
                __( 'Ascending', 'avo_plg' ) => 'ASC',
                __( 'Random', 'avo_plg' ) => 'rand',
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Orders', 'avo_plg' ),
            'param_name' => 'port_column',
            'value' => array(
                __( 'Two Columns', 'avo_plg' ) => '1',
                __( 'Three Columns', 'avo_plg' ) => '2',
                __( 'Four Columns', 'avo_plg' ) => '3',
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Sort Product by Product Category', 'avo_plg' ),
            'param_name' => 'page_show',
            'value' => array(
                __( 'Show', 'avo_plg' ) => 'yes',
                __( 'Hide', 'avo_plg' ) => 'no',
            ),
            'dependency' => array(
                'element' => 'sort_cat',
                'value' => array(
                    'no',
                ),
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'General', 'avo_plg' ),
            'heading' => __( 'Pagination Alignment', 'avo_plg' ),
            'param_name' => 'page_align',
            'value' => array(
                __( 'Left', 'avo_plg' ) => 'left',
                __( 'Center', 'avo_plg' ) => 'center',
                __( 'Right', 'avo_plg' ) => 'right',
            ),
            'dependency' => array(
                'element' => 'page_show',
                'value' => array(
                    'yes',
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Product Item Settings', 'avo_plg' ),
            'heading' => __( 'Margin', 'avo_plg' ),
            'param_name' => 'product_margin',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Product Item Settings', 'avo_plg' ),
            'heading' => __( 'Height', 'avo_plg' ),
            'param_name' => 'product_height',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Margin Top', 'avo_plg' ),
            'param_name' => 'port_content_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Margin Right', 'avo_plg' ),
            'param_name' => 'port_content_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Margin Bottom', 'avo_plg' ),
            'param_name' => 'port_content_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Margin Left', 'avo_plg' ),
            'param_name' => 'port_content_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Padding Top', 'avo_plg' ),
            'param_name' => 'port_padding_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Padding Right', 'avo_plg' ),
            'param_name' => 'port_padding_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Padding Bottom', 'avo_plg' ),
            'param_name' => 'port_padding_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'textfield',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __( 'Content Padding Left', 'avo_plg' ),
            'param_name' => 'port_padding_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ), 
        array(
            'type' => 'colorpicker',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __('Content Background', 'avo_plg'),
            'param_name' => 'bg_content',
            'dependency' => array(
                'element' => 'port_style',
                'value' => array(
                    'style-1',
                ),
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'Content Settings', 'avo_plg' ),
            'heading' => __('Alignment', 'avo_plg'),
            'param_name' => 'content_align',
            'value' => array(
                __( 'Left', 'avo_plg' ) => 'left',
                __( 'Center', 'avo_plg' ) => 'center', 
                __( 'Right', 'avo_plg' ) => 'right', 
            ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __('Title Display', 'avo_plg'),
            'param_name' => 'title_type',
            'value' => array(
                __( 'Block', 'avo_plg' ) => 'block',
                __( 'Inline-Block', 'avo_plg' ) => 'inline-block',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __('Title Color', 'avo_plg'),
            'param_name' => 'title_cl',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __('Title Background Color', 'avo_plg'),
            'param_name' => 'title_bgl',
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Padding Top', 'avo_plg' ),
            'param_name' => 'titlep_padding_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Padding Right', 'avo_plg' ),
            'param_name' => 'titlep_padding_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Padding Bottom', 'avo_plg' ),
            'param_name' => 'titlep_padding_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Padding Left', 'avo_plg' ),
            'param_name' => 'titlep_padding_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Margin Top', 'avo_plg' ),
            'param_name' => 'titlep_margin_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Margin Right', 'avo_plg' ),
            'param_name' => 'titlep_margin_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Margin Bottom', 'avo_plg' ),
            'param_name' => 'titlep_margin_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Title Content Settings', 'avo_plg' ),
            'heading' => __( 'Title Margin Left', 'avo_plg' ),
            'param_name' => 'titlep_margin_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __('Text Display', 'avo_plg'),
            'param_name' => 'text_type',
            'value' => array(
                __( 'Block', 'avo_plg' ) => 'block',
                __( 'Inline-Block', 'avo_plg' ) => 'inline-block',
            ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __('Text Color', 'avo_plg'),
            'param_name' => 'txt_cl',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __('Text Background Color', 'avo_plg'),
            'param_name' => 'txt_bg',
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Padding Top', 'avo_plg' ),
            'param_name' => 'tx_padding_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Padding Right', 'avo_plg' ),
            'param_name' => 'tx_padding_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Padding Bottom', 'avo_plg' ),
            'param_name' => 'tx_padding_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Padding Left', 'avo_plg' ),
            'param_name' => 'tx_padding_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Margin Top', 'avo_plg' ),
            'param_name' => 'tx_margin_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Margin Right', 'avo_plg' ),
            'param_name' => 'tx_margin_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Margin Bottom', 'avo_plg' ),
            'param_name' => 'tx_margin_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Category/Text Content Settings', 'avo_plg' ),
            'heading' => __( 'Text Margin Left', 'avo_plg' ),
            'param_name' => 'tx_margin_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Filter Container Margin Top', 'avo_plg' ),
            'param_name' => 'filter_margin_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Filter Container Margin Right', 'avo_plg' ),
            'param_name' => 'filter_margin_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Filter Container Margin Bottom', 'avo_plg' ),
            'param_name' => 'filter_margin_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Filter Container Margin Left', 'avo_plg' ),
            'param_name' => 'filter_margin_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Padding Top', 'avo_plg' ),
            'param_name' => 'filter_padding_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Padding Right', 'avo_plg' ),
            'param_name' => 'filter_padding_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Padding Bottom', 'avo_plg' ),
            'param_name' => 'filter_padding_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Padding Left', 'avo_plg' ),
            'param_name' => 'filter_padding_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Margin Top', 'avo_plg' ),
            'param_name' => 'filter_linkmargin_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Margin Right', 'avo_plg' ),
            'param_name' => 'filter_linkmargin_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Margin Bottom', 'avo_plg' ),
            'param_name' => 'filter_linkmargin_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Margin Left', 'avo_plg' ),
            'param_name' => 'filter_linkmargin_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Radius Top Left', 'avo_plg' ),
            'param_name' => 'filter_border_radius_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Radius Top Right', 'avo_plg' ),
            'param_name' => 'filter_border_radius_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Radius Bottom Right', 'avo_plg' ),
            'param_name' => 'filter_border_radius_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Radius Bottom Left', 'avo_plg' ),
            'param_name' => 'filter_border_radius_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Color', 'avo_plg'),
            'param_name' => 'color_def',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Background Color', 'avo_plg'),
            'param_name' => 'color_bgdef',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Color on Hover & Active', 'avo_plg'),
            'param_name' => 'color_hov',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Background Color on Hover & Active', 'avo_plg'),
            'param_name' => 'color_bgdefhover',
        ),
        array(
            'type' => 'dropdown',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Border Type', 'avo_plg'),
            'param_name' => 'border_type',
            'value' => array(
                __( 'None', 'avo_plg' ) => 'none',
                __( 'Solid', 'avo_plg' ) => 'solid',
                __( 'Double', 'avo_plg' ) => 'double',
                __( 'Dotted', 'avo_plg' ) => 'dotted',
                __( 'Dashed', 'avo_plg' ) => 'dashed',
                __( 'Groove', 'avo_plg' ) => 'groove',
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Width Top', 'avo_plg' ),
            'param_name' => 'border_width_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
            'dependency' => array(
                'element' => 'border_type',
                'value' => array(
                    'solid',
                    'double',
                    'dotted',
                    'dashed',
                    'groove',
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Width Right', 'avo_plg' ),
            'param_name' => 'border_width_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
            'dependency' => array(
                'element' => 'border_type',
                'value' => array(
                    'solid',
                    'double',
                    'dotted',
                    'dashed',
                    'groove',
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Width Bottom', 'avo_plg' ),
            'param_name' => 'border_width_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
            'dependency' => array(
                'element' => 'border_type',
                'value' => array(
                    'solid',
                    'double',
                    'dotted',
                    'dashed',
                    'groove',
                ),
            ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __( 'Border Width Left', 'avo_plg' ),
            'param_name' => 'border_width_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
            'dependency' => array(
                'element' => 'border_type',
                'value' => array(
                    'solid',
                    'double',
                    'dotted',
                    'dashed',
                    'groove',
                ),
            ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Border Color', 'avo_plg'),
            'param_name' => 'color_border',
            'dependency' => array(
                'element' => 'border_type',
                'value' => array(
                    'solid',
                    'double',
                    'dotted',
                    'dashed',
                    'groove',
                ),
            ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Filter Settings', 'avo_plg' ),
            'heading' => __('Border Color on Hover & Active', 'avo_plg'),
            'param_name' => 'color_borderhover',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Product Mask Settings', 'avo_plg' ),
            'heading' => __('Mask Color', 'avo_plg'),
            'param_name' => 'mask_color',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Product Mask Settings', 'avo_plg' ),
            'heading' => __('Second Mask Color', 'avo_plg'),
            'param_name' => 'mask_color2',
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Product Mask Settings', 'avo_plg' ),
            'heading' => __( 'Second Mask Top Posisition (on hover)', 'avo_plg' ),
            'param_name' => 'mask_post2',
            'description' => __( 'Please add value from -200 to 200 with the unit (for example: 100px or 100%).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Product Mask Settings', 'avo_plg' ),
            'heading' => __( 'Mask Color Opacity (on hover)', 'avo_plg' ),
            'param_name' => 'mask_color_opacity',
            'description' => __( 'Please add value from 0 to 1 (for example: 0.1).', 'avo_plg' ),
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Color', 'avo_plg'),
            'param_name' => 'page_color',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Color on Hover', 'avo_plg'),
            'param_name' => 'page_color_hover',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Background Color', 'avo_plg'),
            'param_name' => 'page_color_bg',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Background Color on Hover', 'avo_plg'),
            'param_name' => 'page_color_hover_bg',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Color on Active', 'avo_plg'),
            'param_name' => 'page_color_active',
        ),
        array(
            'type' => 'colorpicker',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __('Pagination Background Color on Active', 'avo_plg'),
            'param_name' => 'page_color_hover_bg_active',
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __( 'Margin Top', 'avo_plg' ),
            'param_name' => 'pagi_margin_top',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __( 'Margin Right', 'avo_plg' ),
            'param_name' => 'pagi_margin_right',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __( 'Margin Bottom', 'avo_plg' ),
            'param_name' => 'pagi_margin_bottom',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
        array(
            'type' => 'textfield',
            'group' => __( 'Pagination Setting', 'avo_plg' ),
            'heading' => __( 'Margin Left', 'avo_plg' ),
            'param_name' => 'pagi_margin_left',
            'description' => __( 'Please add the unit (for example: px or %).', 'avo_plg' ),
        ),
    )
));

?>
